using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Data;
using System.Windows.Forms;
using gov.va.med.vbecs;

namespace gov.va.med.vbecs.GUI
{


		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		/// User control which displays VBECS logo and screen title on form 
		///</summary>

		#endregion


	public class VbecsLogo : System.Windows.Forms.Panel
	{
		//
		private PictureBox logo;
		private int _height;
		private int _width;
		private int _x;
		private int _y = 7;
		//
		private String title;
		private System.Windows.Forms.PictureBox picDrop;
		private System.EventHandler onTitleChanged;

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// VbecsLogo class constructor
		/// </summary>
		public VbecsLogo() 
		{
			InitializeComponent();
			this.SetStyle(ControlStyles.AllPaintingInWmPaint,true);
			this.SetStyle(ControlStyles.UserPaint,true);
			this.SetStyle(ControlStyles.DoubleBuffer,true);
			this.logo.Image = controls.VbecsImage.VbecsLogo.Image;
			//
			try
			{
				if (Common.VbecsConfig.Current.EnvironmentType.ToUpper() == "M")
				{
					this.logo.Image = controls.VbecsImage.VbecsTestLogo.Image;
				}
			}
			catch
			{
				//This will fail at design time
				//Which is fine!
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// VbecsLogo class constructor. Sets title to display in logo
		/// </summary>
		/// <param name="titleText">Title</param>
		public VbecsLogo(string titleText) : base()
		{
			this.Title = titleText;
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(VbecsLogo));
			this.logo = new System.Windows.Forms.PictureBox();
			this.picDrop = new System.Windows.Forms.PictureBox();
			this.SuspendLayout();
			// 
			// logo
			// 
			this.logo.Dock = System.Windows.Forms.DockStyle.Right;
			this.logo.Image = ((System.Drawing.Image)(resources.GetObject("logo.Image")));
			this.logo.Location = new System.Drawing.Point(1012, 0);
			this.logo.Name = "logo";
			this.logo.Size = new System.Drawing.Size(60, 30);
			this.logo.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.logo.TabIndex = 0;
			this.logo.TabStop = false;
			// 
			// picDrop
			// 
			this.picDrop.BackColor = System.Drawing.Color.Transparent;
			this.picDrop.Image = ((System.Drawing.Image)(resources.GetObject("picDrop.Image")));
			this.picDrop.Location = new System.Drawing.Point(2, 2);
			this.picDrop.Name = "picDrop";
			this.picDrop.Size = new System.Drawing.Size(18, 25);
			this.picDrop.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.picDrop.TabIndex = 1;
			this.picDrop.TabStop = false;
			// 
			// VbecsLogo
			// 
			this.Controls.Add(this.picDrop);
			this.Controls.Add(this.logo);
			this.Font = new System.Drawing.Font("Arial", 10F, System.Drawing.FontStyle.Bold);
			this.ForeColor = System.Drawing.Color.AntiqueWhite;
			this.Name = "VbecsLogo";
			this.Size = new System.Drawing.Size(1072, 30);
			this.ForeColorChanged += new System.EventHandler(this.VbecsLogo_ForeColorChanged);
			this.SizeChanged += new System.EventHandler(this.VbecsLogo_SizeChanged);
			this.FontChanged += new System.EventHandler(this.VbecsLogo_FontChanged);
			this.BackColorChanged += new System.EventHandler(this.VbecsLogo_BackColorChanged);
			this.ResumeLayout(false);

		}
		#endregion

		#region Properties

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Gets or sets title to display in logo
		/// </summary>
		[
		Category("Appearance"),
		Description("Title to display next to logo"),
		DefaultValue("Title..."),
		Bindable(true),
		Browsable(true),
		]
		public String Title
		{
			get 
			{ 
				return title; 
			}
			set 
			{
				title=value;
				if (onTitleChanged!=null) 
				{
					onTitleChanged(null,EventArgs.Empty);
				}
				this.Invalidate();
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Gets or sets docking style property
		/// </summary>
		[Browsable(false)]
		public override DockStyle Dock 
		{
			get 
			{ 
				return base.Dock; 
			}
			set 
			{ 
				base.Dock = value; 
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Gets or sets anchor style property
		/// </summary>
		[Browsable(false)]
		public override AnchorStyles Anchor
		{
			get { return base.Anchor; }
			set { base.Anchor = value; }
		}

		#endregion

		#region Methods

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Private method to build and paint shadowed title bar next to logo
		/// </summary>
		/// <param name="pe">Paint event args</param>
		private void PaintTitleBar(PaintEventArgs pe)
		{
			Graphics e = pe.Graphics;
			// Draw Main ShadowBox
			DrawShadowBoxWithText(e,this.Title,this.Font,0,7,this.Width-62,17);
			// Build path for Drop
			//GraphicsPath pathDrop = BuildDrop();
			// Build path for Star
			//GraphicsPath pathStar = BuildStar();
			// Build shadowed drop Region
			//Region Drop = new Region(pathDrop);
			//Drop.Exclude(pathStar);
			//Region Shadow = Drop.Clone();
			//Shadow.Translate(1,1);
			//Region Star = new Region(pathStar);
			// Draw Shadowed Drop
			//e.FillRegion(Brushes.AntiqueWhite, Star);
			//e.FillRegion(Brushes.Black, Shadow);
			//e.FillRegion(new SolidBrush(Color.FromArgb(230,Color.Red)), Drop);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Private method to draw title as shadowed text
		/// </summary>
		/// <param name="g">Graphics</param>
		/// <param name="message">String</param>
		/// <param name="font">Font</param>
		/// <param name="x">Int</param>
		/// <param name="y">Int</param>
		/// <param name="width">Int</param>
		/// <param name="height">Int</param>
		private void DrawShadowBoxWithText(Graphics g, string message, Font font, int x, int y, int width, int height)
		{
			StringFormat strfmt = new StringFormat();
			strfmt.Alignment = StringAlignment.Far;
			_width = width;
			_height = height;
			_x = x;
			_y = y;
			//
			Rectangle rect = new Rectangle(new Point(x,y),new Size(width,height));
			//
			rect.Offset(1,1);
			g.FillRectangle(new LinearGradientBrush(rect,this.BackColor,Color.Black,0F),rect);
			// Draw Box
			rect.Offset(-1,-1);
			g.FillRectangle(new LinearGradientBrush(rect,this.BackColor,Color.FromArgb(230,Color.Red),0F),rect);
			// Draw Text Shadow
			rect.Offset(1,1);
			g.DrawString(message,font,new SolidBrush(Color.FromArgb(90,Color.Black)),rect,strfmt);
			// Draw Text
			rect.Offset(-1,-1);
			g.DrawString(message,font,new SolidBrush(this.ForeColor),rect,strfmt);
		}

		#endregion

		#region Events

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary> 
		/// Title changed event
		/// </summary>
		[Description("Raised when the Title changes")]
		public event EventHandler TitleChanged 
		{
			add 
			{
				onTitleChanged += value; 
			}
			remove 
			{ 
				onTitleChanged -= value; 
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Paint event handler
		/// </summary>
		/// <param name="pe">Paint event args</param>
		protected override void OnPaint(PaintEventArgs pe)
		{
			PaintTitleBar(pe);
			base.OnPaint(pe);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary> 
		/// Logo size changed event handler
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void VbecsLogo_SizeChanged(object sender, System.EventArgs e)
		{
			this.Invalidate();
			//PaintTitleBar();
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary> 
		/// Logo font changed event handler
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void VbecsLogo_FontChanged(object sender, System.EventArgs e)
		{
			this.Invalidate();
			//PaintTitleBar();
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary> 
		/// Logo fore color changed event handler
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void VbecsLogo_ForeColorChanged(object sender, System.EventArgs e)
		{
			this.Invalidate();
			//PaintTitleBar();
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary> 
		/// Logo back color changed event handler
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void VbecsLogo_BackColorChanged(object sender, System.EventArgs e)
		{
			this.Invalidate();
			//PaintTitleBar();
		}
		//

		#endregion


	}
}
